/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.concurrent.Executor;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record ServerBoundSetSpeakerBlockPacket(BlockPos pos, String str, SpeakerBlockTile.Mode mode, double volume) implements Message
{
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ServerBoundSetSpeakerBlockPacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("c2s_set_speaker"), ServerBoundSetSpeakerBlockPacket::new);

    public ServerBoundSetSpeakerBlockPacket(FriendlyByteBuf buf) {
        this(buf.readBlockPos(), buf.readUtf(), (SpeakerBlockTile.Mode)buf.readEnum(SpeakerBlockTile.Mode.class), buf.readDouble());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeUtf(this.str);
        buf.writeEnum((Enum)this.mode);
        buf.writeDouble(this.volume);
    }

    public void handle(Message.Context context) {
        BlockEntity blockEntity;
        BlockPos pos;
        ServerPlayer sender;
        Level level;
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer && (level = (sender = (ServerPlayer)player).level()).hasChunkAt(pos = this.pos) && (blockEntity = level.getBlockEntity(pos)) instanceof SpeakerBlockTile) {
            SpeakerBlockTile speaker = (SpeakerBlockTile)blockEntity;
            speaker.setVolume(this.volume);
            speaker.setMode(this.mode);
            sender.connection.filterTextPacket(this.str).thenAcceptAsync(l -> this.updateSpeakerText(sender, (FilteredText)l), (Executor)sender.server);
        }
    }

    private void updateSpeakerText(ServerPlayer player, FilteredText filteredText) {
        SpeakerBlockTile be;
        BlockEntity blockEntity;
        player.resetLastActionTime();
        Level level = player.level();
        if (level.hasChunkAt(this.pos) && (blockEntity = level.getBlockEntity(this.pos)) instanceof SpeakerBlockTile && (be = (SpeakerBlockTile)blockEntity).tryAcceptingClientText(player, filteredText)) {
            level.sendBlockUpdated(be.getBlockPos(), be.getBlockState(), be.getBlockState(), 3);
            be.setChanged();
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

